
#include "extractor/abstract_file.h"
#include "extractor/extractor.h"
#include "extractor/File_Extractor.h"

#include <stdlib.h>
#include <string>
#include <vector>
#include <stdio.h>

using namespace std;
struct archType {
	std::string name;
	std::string path;
};

struct archiveContents {
	string parentPath;
	vector<std::string> archiveList;
};

extern archiveContents archive;
extern int archiveGameSelected;


extern "C" int dprintf(char *format, ...);

extern void handle_error( const char* error );

int loadArchive(char* path)
{
	dprintf("Path to 7-zip file: %s\n", path);
	File_Extractor* arc = 0;
	
	/* Identify file type and open appropriately */
	const char* error = 0;
	const char* type = strrchr( (char*) path, '.' );
	if ( !type ) type = "";
	     if ( !strcmp( type, ".zip" ) ) arc = extractor_open_zip ( path, &error );
	else if ( !strcmp( type, ".7z"  ) ) arc = extractor_open_7zip( path, &error );
	else if ( !strcmp( type, ".rar" ) ) arc = extractor_open_rar ( path, &error );
	else                                arc = extractor_open_file( path, &error );
	handle_error( error );
	

	archive.archiveList.clear();
	/* List files and first few characters of content */
	while ( !extractor_done( arc ) )
	{
		const char* name = extractor_name( arc );
		//long        size = extractor_size( arc );
		//char buf [60] = "";
		std::string t = name;
		archive.archiveList.push_back(t);



		
		/* print size and name */
		//dprintf( "## %3d K  %s\n", (size + 1023) / 1024, name );
		
		/* print first several characters of data */
		//handle_error( extractor_read( arc, buf, (size < 59 ? size : 59) ) );
		//dprintf( "%s\n", buf );
		
		/* go to next file in archive (skips directories) */
		handle_error( extractor_next( arc ) );
	}
	
	/* Cleanup */
	extractor_close( arc );
	
	return 0;
}



archType extractArchive(char* path, int index)
{
	dprintf("Extract Path to 7-zip file: %s\n", path);
	File_Extractor* arc = 0;
	
	/* Identify file type and open appropriately */
	const char* error = 0;
	const char* type = strrchr( (char*) path, '.' );
	if ( !type ) type = "";
	
	
	dprintf("Open File Begin\n");
	if ( !strcmp( type, ".zip" ) ) arc = extractor_open_zip ( path, &error );
	else if ( !strcmp( type, ".7z"  ) ) arc = extractor_open_7zip( path, &error );
	else if ( !strcmp( type, ".rar" ) ) arc = extractor_open_rar ( path, &error );
	else                                arc = extractor_open_file( path, &error );
	handle_error( error );
	dprintf("Open File End\n");

	int i = 0;
	archType a;
	/* List files and first few characters of content */
	while ( !extractor_done( arc ) )
	{
		if(i == 0) { //index) {
			

			const char* name = extractor_name( arc );
			a.name = name;
			
			std::string t = "X:\\";
			t += name;

			a.path = t;

			Std_File_Writer out;

			dprintf("Open file to write to X\n");
			handle_error( out.open( t.c_str() ) );
			dprintf("Extract file to write to X\n");
			handle_error( arc->extract( out ) );
			out.close();
			extractor_close( arc );
			return a;
		}
		else {
			i++;

			dprintf("Begin move to next file\n");
			handle_error( extractor_next( arc ) );
			dprintf("End move to next file\n");
		}
	}
	
	/* Cleanup */
	extractor_close( arc );
	
	return a;
}


/*
if(i == index) {
			dprintf("Extracting file: %d\n", index);
			const char* name = extractor_name( arc );
			long        size = extractor_size( arc );
			char *buf = new char[size];


			dprintf("Read begin\n");
			handle_error( extractor_read( arc, buf, size ));
			dprintf("Read end\n");


			std::string t = "X:\\";
			t += name;
			FILE *fp = fopen(t.c_str(), "wb");
			

			if(!fp) { dprintf("FP IS NULL\n"); extractor_close( arc ); return 0; }


			dprintf("Try to write %d bytes.\n", size);
			int res = fwrite(buf,1, size, fp);
			dprintf("Actually wrote %d bytes.\n", res);

			fclose(fp);

			extractor_close( arc );
			return 0;
		}
		else {
			i++;

			dprintf("Begin move to next file\n");
			handle_error( extractor_next( arc ) );
			dprintf("End move to next file\n");
		}

*/